/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.math;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.animation.state.ControllerState;
import software.bernie.geckolib.loading.math.value.Variable;

public interface MathValue
extends ToDoubleFunction<ControllerState> {
    public double get(ControllerState var1);

    default public boolean isMutable() {
        return true;
    }

    default public Set<Variable> getUsedVariables() {
        return Set.of();
    }

    @ApiStatus.Internal
    public static Set<Variable> collectUsedVariables(MathValue ... values) {
        if (values.length == 0) {
            return Set.of();
        }
        if (values.length == 1) {
            return values[0].getUsedVariables();
        }
        ReferenceOpenHashSet usedVariables = new ReferenceOpenHashSet();
        for (MathValue value : values) {
            usedVariables.addAll(value.getUsedVariables());
        }
        return usedVariables;
    }

    @Override
    @Deprecated
    @ApiStatus.Internal
    default public double applyAsDouble(ControllerState controllerState) {
        return this.get(controllerState);
    }
}

